/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.item.BFItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MaizeCropBlock
extends CropBlock
implements BonemealableBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF;
    public static final IntegerProperty AGE;
    public static final VoxelShape[] LOWER_SHAPES;
    public static final VoxelShape[] UPPER_SHAPES;

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return switch ((Integer)state.m_61143_((Property)AGE)) {
                case 0 -> LOWER_SHAPES[0];
                case 1 -> LOWER_SHAPES[1];
                case 2 -> LOWER_SHAPES[2];
                default -> LOWER_SHAPES[3];
            };
        }
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return switch ((Integer)state.m_61143_((Property)AGE)) {
                case 0, 1, 2, 3, 4 -> UPPER_SHAPES[0];
                case 5 -> UPPER_SHAPES[1];
                default -> UPPER_SHAPES[2];
            };
        }
        return LOWER_SHAPES[3];
    }

    public MaizeCropBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    private boolean isFullyGrown(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) >= 7;
    }

    public boolean m_6724_(BlockState state) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER && !this.isFullyGrown(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.m_49966_();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : state;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (!MaizeCropBlock.isLowerHalf(state)) {
            return super.m_7898_(state, world, pos) || world.m_8055_(pos.m_7495_()).m_60713_((Block)this);
        }
        return super.m_6266_(world.m_8055_(pos.m_7495_()), (BlockGetter)world, pos.m_7495_()) && MaizeCropBlock.canPlaceAt(world, pos) && ((Integer)state.m_61143_((Property)AGE) < 4 || MaizeCropBlock.isUpperHalf(world.m_8055_(pos.m_7494_())));
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)BFItems.MAIZE_SEEDS);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, HALF});
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (doubleBlockHalf == DoubleBlockHalf.LOWER && (Integer)state.m_61143_((Property)AGE) < 7) {
            MaizeCropBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)BFItems.MAIZE_SEEDS.m_7968_());
        }
        if (!world.f_46443_) {
            if (player.m_7500_()) {
                MaizeCropBlock.onBreakInCreative(world, pos, state, player);
            } else {
                MaizeCropBlock.m_49881_((BlockState)state, (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(world, pos, state, player);
    }

    protected static void onBreakInCreative(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (doubleBlockHalf == DoubleBlockHalf.UPPER && (blockState = world.m_8055_(blockPos = pos.m_7495_())).m_60713_(state.m_60734_()) && blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockState2 = blockState.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            world.m_7731_(blockPos, blockState2, 35);
            world.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.m_45524_(pos, 0) >= 9) {
            boolean bl;
            float f = CropBlock.m_52272_((Block)this, (BlockGetter)world, (BlockPos)pos);
            boolean bl2 = bl = random.m_188503_((int)(25.0f / f) + 1) == 0;
            if (bl) {
                this.tryGrow(world, state, pos);
            }
        }
    }

    private void tryGrow(ServerLevel world, BlockState state, BlockPos pos) {
        int i = Math.min((Integer)state.m_61143_((Property)AGE) + 1, 7);
        if (this.canGrow((LevelReader)world, pos, state, i)) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
            if (i >= 4) {
                BlockPos blockPos = pos.m_7494_();
                world.m_7731_(blockPos, MaizeCropBlock.withWaterloggedState((LevelReader)world, pos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(i))).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)), 3);
            }
        }
    }

    private static boolean canGrowAt(LevelReader world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        return blockState.m_60795_() || blockState.m_60713_(BFBlocks.MAIZE_CROP);
    }

    private static boolean canPlaceAt(LevelReader world, BlockPos pos) {
        return world.m_45524_(pos, 0) >= 8 || world.m_45527_(pos);
    }

    private static boolean isLowerHalf(BlockState state) {
        return state.m_60713_(BFBlocks.MAIZE_CROP) && state.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    private static boolean isUpperHalf(BlockState state) {
        return state.m_60713_(BFBlocks.MAIZE_CROP) && state.m_61143_(HALF) == DoubleBlockHalf.UPPER;
    }

    private boolean canGrow(LevelReader world, BlockPos pos, BlockState state, int age) {
        return !this.isFullyGrown(state) && MaizeCropBlock.canPlaceAt(world, pos) && (age < 3 || MaizeCropBlock.canGrowAt(world, pos.m_7494_()));
    }

    @Nullable
    private LowerHalfContext getLowerHalfContext(LevelReader world, BlockPos pos, BlockState state) {
        if (MaizeCropBlock.isLowerHalf(state)) {
            return new LowerHalfContext(pos, state);
        }
        BlockPos blockPos = pos.m_7495_();
        BlockState blockState = world.m_8055_(blockPos);
        return MaizeCropBlock.isLowerHalf(blockState) ? new LowerHalfContext(blockPos, blockState) : null;
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        LowerHalfContext lowerHalfContext = this.getLowerHalfContext(world, pos, state);
        return lowerHalfContext != null && this.canGrow(world, lowerHalfContext.pos, lowerHalfContext.state, (Integer)lowerHalfContext.state.m_61143_((Property)AGE) + 1);
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        LowerHalfContext lowerHalfContext = this.getLowerHalfContext((LevelReader)world, pos, state);
        if (lowerHalfContext != null) {
            this.tryGrow(world, lowerHalfContext.state, lowerHalfContext.pos);
        }
    }

    public static BlockState withWaterloggedState(LevelReader world, BlockPos pos, BlockState state) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_46801_(pos))) : state;
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.m_6240_(world, player, pos, Blocks.f_50016_.m_49966_(), blockEntity, tool);
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_6625_(state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)pos.m_123343_());
    }

    static {
        LOWER_SHAPES = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
        UPPER_SHAPES = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
        AGE = BlockStateProperties.f_61409_;
        HALF = BlockStateProperties.f_61401_;
    }

    private record LowerHalfContext(BlockPos pos, BlockState state) {
    }
}

